/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10526;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_11566;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class ClipboardModel
implements class_10439 {
    public static final class_2960 ID = class_2960.method_60655((String)"create", (String)"model/clipboard");
    public static final class_2960 EMPTY_ID = class_2960.method_60655((String)"create", (String)"item/clipboard_0");
    public static final class_2960 WRITTEN_ID = class_2960.method_60655((String)"create", (String)"item/clipboard_1");
    public static final class_2960 EDITING_ID = class_2960.method_60655((String)"create", (String)"item/clipboard_2");
    private final class_1921 layer = class_4722.method_29382();
    private final ModelData[] models;

    public ClipboardModel(ModelData[] models) {
        this.models = models;
    }

    public void method_65584(class_10444 state, class_1799 stack, class_10442 resolver, class_811 displayContext, @Nullable class_638 world, @Nullable class_11566 user, int seed) {
        int index = ((ClipboardContent)stack.method_58695(AllDataComponents.CLIPBOARD_CONTENT, (Object)ClipboardContent.EMPTY)).type().ordinal();
        state.method_70946((Object)this);
        state.method_70946((Object)index);
        this.models[index].update(state, this.layer, displayContext);
    }

    @Environment(value=EnvType.CLIENT)
    public record ModelData(List<class_777> quads, class_10809 settings, Supplier<Vector3fc[]> vector) {
        public static ModelData bake(class_7775 baker, class_2960 id) {
            class_10819 model = baker.method_45872(id);
            class_10419 textures = model.method_68045();
            List quads = model.method_68034(textures, baker, (class_3665)class_1086.field_63619).method_68048();
            class_10809 settings = class_10809.method_68001((class_7775)baker, (class_10819)model, (class_10419)textures);
            return new ModelData(quads, settings, (Supplier<Vector3fc[]>)Suppliers.memoize(() -> class_10430.method_67990((List)quads)));
        }

        public void update(class_10444 state, class_1921 layer, class_811 displayContext) {
            class_10444.class_10446 layerRenderState = state.method_65601();
            layerRenderState.method_67992(layer);
            layerRenderState.method_67995(this.vector);
            this.settings.method_68000(layerRenderState, displayContext);
            layerRenderState.method_67997().addAll(this.quads);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Unbaked
    implements class_10439.class_10441 {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<Unbaked> method_65585() {
            return CODEC;
        }

        public void method_62326(class_10526.class_10103 resolver) {
            resolver.markDependency(EMPTY_ID);
            resolver.markDependency(WRITTEN_ID);
            resolver.markDependency(EDITING_ID);
        }

        public class_10439 method_65587(class_10439.class_10440 context) {
            class_7775 baker = context.comp_3390();
            ModelData[] models = new ModelData[]{ModelData.bake(baker, EMPTY_ID), ModelData.bake(baker, WRITTEN_ID), ModelData.bake(baker, EDITING_ID)};
            return new ClipboardModel(models);
        }
    }
}

